package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Facility;
import gov.va.vinci.dart.db.FacilityDAO;

public class FacilityDAOMock implements FacilityDAO {

	private static final HashMap<Integer,Facility> IDHash = new HashMap<Integer,Facility>();
	private static boolean initialized = false;

	@Override
	public Facility findById(int locationId) {

		initializeFaciliytHash();
		
		return IDHash.get(locationId);
	}

	@Override
	public Facility findByName(String name) throws ObjectNotFoundException {

		initializeFaciliytHash();

		for (Integer id: IDHash.keySet()) {
			Facility facility = IDHash.get(id);
			if (facility.getName().equals(name)) {
				return facility;
			}
		}

		return null;
	}

	@Override
	public List<Facility> listAll() {
		List<Facility> result = new ArrayList<Facility>();
		
		initializeFaciliytHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	private void initializeFaciliytHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
		
		MyFacility fac = new MyFacility();
		fac.setId(1);
		fac.setName("Test Facility One");
		IDHash.put(1, fac);
	}
	
	static class MyFacility extends Facility {
		public MyFacility() {
			super();
		}
		
		public void setId(int id) {
			this.id = id;
		}
		
		public void setName(final String name) {
			this.name = name;
		}
	}
}
